/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWorkConfirmDialog;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.Frame;
import java.util.Vector;

public final class VWUnlockWork
implements IVWPropertyChangeSource {
    private Vector m_participants = null;
    private Frame m_parent;
    private VWTrkDataModel m_dataModel = null;
    private Vector m_selectionFlags = null;
    private boolean m_bUnlocked = false;
    private boolean m_bCanceled = false;
    private int m_propertyChangeEventType = 0;

    public VWUnlockWork(Frame parent, VWTrkDataModel dataModel) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(dataModel);
    }

    public VWUnlockWork(Frame parent, VWTrkDataModel dataModel, Vector steps) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(steps);
    }

    public VWUnlockWork(Frame parent, VWTrkDataModel dataModel, Object[] steps) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(steps);
    }

    public VWUnlockWork(Frame parent, VWTrkStepOccurrence occurrence) throws Exception {
        this.m_parent = parent;
        this.initializeData(occurrence);
    }

    public VWUnlockWork(Frame parent, VWTrkParticipant participant) throws Exception {
        this.m_parent = parent;
        this.initializeData(participant);
    }

    private void initializeData(Object data) throws Exception {
        if (data == null) {
            this.m_participants = null;
            return;
        }
        this.m_participants = new Vector();
        if (data instanceof VWTrkDataModel) {
            data = ((VWTrkDataModel)data).getStepCollection();
        }
        if (data instanceof Vector) {
            this.initData((Vector)data);
        }
        if (data instanceof Object[]) {
            this.initData((Object[])data);
        } else if (data instanceof VWTrkStep) {
            this.initData((VWTrkStep)data);
        } else if (data instanceof VWTrkStepOccurrence) {
            this.initData((VWTrkStepOccurrence)data);
        } else if (data instanceof VWTrkParticipant) {
            this.initData((VWTrkParticipant)data);
        }
    }

    private void initData(Vector vector) throws Exception {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object obj = vector.elementAt(i);
            if (obj == null) continue;
            if (obj instanceof VWTrkStep) {
                this.initData((VWTrkStep)obj);
                continue;
            }
            if (obj instanceof VWTrkStepOccurrence) {
                this.initData((VWTrkStepOccurrence)obj);
                continue;
            }
            if (obj instanceof VWTrkParticipant) {
                this.initData((VWTrkParticipant)obj);
                continue;
            }
            if (!(obj instanceof VWStepDefinition)) continue;
            if (this.m_dataModel != null) {
                this.initData(this.m_dataModel.findStep(((VWStepDefinition)obj).getStepId()));
                continue;
            }
            throw new Exception(VWResource.s_needDataModel.toString(VWResource.s_unlockWork));
        }
    }

    private void initData(Object[] array) throws Exception {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if (obj == null) continue;
            if (obj instanceof VWTrkStep) {
                this.initData((VWTrkStep)obj);
                continue;
            }
            if (obj instanceof VWTrkStepOccurrence) {
                this.initData((VWTrkStepOccurrence)obj);
                continue;
            }
            if (obj instanceof VWTrkParticipant) {
                this.initData((VWTrkParticipant)obj);
                continue;
            }
            if (!(obj instanceof VWStepDefinition)) continue;
            if (this.m_dataModel != null) {
                this.initData(this.m_dataModel.findStep(((VWStepDefinition)obj).getStepId()));
                continue;
            }
            throw new Exception(VWResource.s_needDataModel.toString(VWResource.s_unlockWork));
        }
    }

    private void initData(VWTrkStep step) {
        if (step == null) {
            return;
        }
        Vector activeOccurrences = step.getActiveOccurrences();
        if (activeOccurrences != null) {
            for (int i = 0; i < activeOccurrences.size(); ++i) {
                Object obj = activeOccurrences.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                this.addOccurrence((VWTrkStepOccurrence)obj);
            }
        }
    }

    private void initData(VWTrkStepOccurrence occurrence) {
        if (occurrence == null) {
            return;
        }
        this.addOccurrence(occurrence);
    }

    private void initData(VWTrkParticipant participant) {
        if (participant == null) {
            return;
        }
        this.addParticipant(participant);
    }

    private void addOccurrence(VWTrkStepOccurrence occurrence) {
        if (occurrence == null) {
            return;
        }
        if (occurrence.isActive() && occurrence.isSomeLockedByCurrentUser()) {
            Vector participants = occurrence.getParticipantCollection();
            for (int j = 0; j < participants.size(); ++j) {
                Object obj = participants.elementAt(j);
                if (obj == null || !(obj instanceof VWTrkParticipant)) continue;
                VWTrkParticipant participant = (VWTrkParticipant)participants.elementAt(j);
                this.addParticipant(participant);
            }
        }
    }

    private void addParticipant(VWTrkParticipant participant) {
        if (participant == null) {
            return;
        }
        if (participant.isActive() && participant.isLockedByCurrentUser()) {
            this.m_participants.addElement(participant);
        }
    }

    public void unlockWork() {
        if (this.m_participants == null) {
            return;
        }
        int count = this.m_participants.size();
        if (count == 0) {
            return;
        }
        boolean[] unlockFlags = new boolean[count];
        for (int i = 0; i < count; ++i) {
            unlockFlags[i] = true;
        }
        this.unlock(unlockFlags);
    }

    public void unlockWork(Vector flags) {
        if (this.m_participants == null) {
            return;
        }
        int count = this.m_participants.size();
        if (count == 0) {
            return;
        }
        boolean[] unlockFlags = new boolean[count];
        int flagCount = flags.size();
        boolean flag = false;
        for (int i = 0; i < count; ++i) {
            Object obj;
            flag = false;
            if (i < flagCount && (obj = flags.elementAt(i)) != null && obj instanceof Boolean) {
                flag = (Boolean)obj;
            }
            unlockFlags[i] = flag;
        }
        this.unlock(unlockFlags);
    }

    public void unlockWork(boolean[] flags) {
        if (this.m_participants == null) {
            return;
        }
        int count = this.m_participants.size();
        if (count == 0) {
            return;
        }
        boolean[] unlockFlags = new boolean[count];
        int flagCount = flags.length;
        for (int i = 0; i < count; ++i) {
            unlockFlags[i] = i < flagCount ? flags[i] : false;
        }
        this.unlock(unlockFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(boolean[] unlockFlags) {
        VWTrkParticipant participant;
        int i;
        if (this.m_participants == null) {
            return;
        }
        boolean bAltered = false;
        boolean bSave = false;
        boolean bRefreshed = false;
        for (i = 0; i < this.m_participants.size(); ++i) {
            if (!unlockFlags[i]) continue;
            participant = (VWTrkParticipant)this.m_participants.elementAt(i);
            bAltered |= participant.getIsAltered();
        }
        if (bAltered) {
            VWUnlockWorkConfirmDialog dlg = null;
            try {
                dlg = new VWUnlockWorkConfirmDialog(this.m_parent);
                dlg.setVisible(true);
                if (dlg.isCanceled()) {
                    this.m_bCanceled = true;
                    return;
                }
                bSave = dlg.isYes();
            }
            finally {
                if (dlg != null) {
                    dlg.removeReferences();
                    dlg = null;
                }
            }
            if (!bSave) {
                bRefreshed = true;
            }
        }
        this.m_bUnlocked = true;
        for (i = 0; i < this.m_participants.size(); ++i) {
            if (!unlockFlags[i]) continue;
            participant = (VWTrkParticipant)this.m_participants.elementAt(i);
            this.m_bUnlocked &= participant.unlockWork(bSave, false);
        }
        if (bRefreshed) {
            this.notifyPropertyChange(704);
        }
        this.notifyPropertyChange(701);
    }

    public boolean isAnyParticipant() {
        return this.m_participants != null && this.m_participants.size() > 0;
    }

    public Vector getParticipants() {
        return this.m_participants;
    }

    public boolean isUnlocked() {
        return this.m_bUnlocked;
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public void notifyPropertyChange(int eventType) {
        if (this.m_participants != null && this.m_participants.size() > 0) {
            this.m_propertyChangeEventType = eventType;
            VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, eventType));
        }
    }

    public void notifyPropertyChange() {
        if (this.m_participants != null && this.m_participants.size() > 0) {
            VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, this.m_propertyChangeEventType));
        }
    }

    public Vector getItemsChanged() {
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        if (this.m_participants != null) {
            for (int i = 0; i < this.m_participants.size(); ++i) {
                VWTrkParticipant participant = (VWTrkParticipant)this.m_participants.elementAt(i);
                VWTrkStep step = participant.getStep();
                for (int j = 0; j < steps.size(); ++j) {
                    if (step != steps.elementAt(j)) continue;
                    step = null;
                    break;
                }
                if (step == null) continue;
                steps.addElement(step);
            }
        }
        return steps;
    }

    public void removeReferences() {
        if (this.m_participants != null) {
            this.m_participants.removeAllElements();
            this.m_participants = null;
        }
        this.m_parent = null;
        this.m_dataModel = null;
        if (this.m_selectionFlags != null) {
            this.m_selectionFlags.removeAllElements();
            this.m_selectionFlags = null;
        }
    }
}

